/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.debuffs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.toma.gunsrpg.api.common.attribute.IAttribute;
import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.api.common.attribute.IAttributeModifier;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.attribute.ExpiringModifier;
import dev.toma.gunsrpg.common.debuffs.DebuffType;
import dev.toma.gunsrpg.common.debuffs.DynamicDebuff;
import dev.toma.gunsrpg.common.debuffs.IDebuffBuilder;
import dev.toma.gunsrpg.common.debuffs.IDebuffContext;
import dev.toma.gunsrpg.common.debuffs.IDebuffType;
import dev.toma.gunsrpg.common.debuffs.IStagedDebuff;
import dev.toma.gunsrpg.common.debuffs.event.DebuffStageEvent;
import dev.toma.gunsrpg.common.debuffs.event.DebuffStageEventType;
import dev.toma.gunsrpg.common.debuffs.sources.DebuffSource;
import dev.toma.gunsrpg.common.debuffs.sources.DebuffSourceType;
import dev.toma.gunsrpg.util.function.FloatSupplier;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;

public final class DataDrivenDebuffType<D extends IStagedDebuff>
extends DebuffType<D>
implements DynamicDebuff<LoadedData> {
    public static final Codec<LoadedData> DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DebuffAttributes.CODEC.fieldOf("attributes").forGetter(d -> ((LoadedData)d).attributes), (App)DebuffStage.CODEC.listOf().fieldOf("stages").forGetter(d -> ((LoadedData)d).stages), (App)DebuffSourceType.SOURCE_CODEC.listOf().fieldOf("sources").forGetter(d -> ((LoadedData)d).sources)).apply((Applicative)instance, LoadedData::new));
    private final FloatSupplier globalChanceMultiplier;
    private DebuffAttributes attributes;
    private List<DebuffStage> stages;
    private List<DebuffSource> sources;

    public DataDrivenDebuffType(Builder<D> builder) {
        super(builder);
        this.globalChanceMultiplier = ((Builder)builder).chanceMultiplier;
    }

    @Override
    public D onTrigger(IDebuffContext context, Random random, @Nullable Object data) {
        float resistChance;
        IPlayerData playerData = context.getData();
        IAttributeProvider provider = playerData.getAttributes();
        float f = resistChance = this.attributes != null && this.attributes.getResistanceAttribute() != null ? provider.getAttribute(this.attributes.getResistanceAttribute()).floatValue() : 0.0f;
        if (this.isDisabledByAttributes(provider) || random.nextFloat() < resistChance && resistChance > 0.0f) {
            return null;
        }
        if (this.sources == null) {
            return null;
        }
        float chanceMultiplier = this.globalChanceMultiplier.getFloat();
        for (DebuffSource source : this.sources) {
            float chance = source.getChance(context) * chanceMultiplier;
            if (!(chance > 0.0f) || !(random.nextFloat() < chance)) continue;
            return (D)((IStagedDebuff)this.createRaw());
        }
        return null;
    }

    @Override
    public int getFlags() {
        return IDebuffType.TriggerFlags.HURT.getValue();
    }

    @Override
    public Codec<LoadedData> getDataCodec() {
        return DATA_CODEC;
    }

    @Override
    public void onDataLoaded(LoadedData data) {
        this.attributes = data.attributes;
        this.stages = data.stages;
        this.sources = data.sources;
    }

    public boolean isDisabledByAttributes(IAttributeProvider provider) {
        return this.attributes != null && this.attributes.blockAttribute != null && provider.getAttribute(this.attributes.blockAttribute).intValue() > 0;
    }

    public DebuffAttributes getAttributes() {
        return this.attributes;
    }

    public List<DebuffStage> getStages() {
        return this.stages;
    }

    public List<DebuffSource> getSources() {
        return this.sources;
    }

    public IAttributeId getBlockingAttribute() {
        return this.attributes.blockAttribute;
    }

    public DebuffStage getStage(int index) {
        return this.stages != null && index >= 0 && index < this.stages.size() ? this.stages.get(index) : DebuffStage.NONE;
    }

    public int getDelay(IPlayerData data) {
        IAttributeProvider provider = data.getAttributes();
        return this.attributes != null && this.attributes.delayAttribute != null ? provider.getAttribute(this.attributes.delayAttribute).intValue() : Integer.MAX_VALUE;
    }

    public static float getBuffedProgress(IAttributeProvider provider, IAttributeId blockingAttribute) {
        IAttribute attribute = provider.getAttribute(blockingAttribute);
        List<IAttributeModifier> list = attribute.listModifiers();
        if (list.isEmpty()) {
            return 0.0f;
        }
        IAttributeModifier modifier = list.get(0);
        if (modifier instanceof ExpiringModifier) {
            ExpiringModifier expiringModifier = (ExpiringModifier)modifier;
            int total = expiringModifier.getInitialTime();
            int left = expiringModifier.getTimeLeft();
            return (float)left / (float)total;
        }
        return 0.0f;
    }

    public static final class Builder<D extends IStagedDebuff>
    implements IDebuffBuilder<D> {
        private DebuffType.IFactory<D> factory;
        private BooleanSupplier isConfigDisabled;
        private FloatSupplier chanceMultiplier;

        public Builder<D> factory(DebuffType.IFactory<D> factory) {
            this.factory = factory;
            return this;
        }

        public Builder<D> config(BooleanSupplier supplier, FloatSupplier chanceMultiplier) {
            this.isConfigDisabled = supplier;
            this.chanceMultiplier = chanceMultiplier;
            return this;
        }

        public DataDrivenDebuffType<D> build() {
            return new DataDrivenDebuffType(this);
        }

        @Override
        public DebuffType.IFactory<D> getFactory() {
            return this.factory;
        }

        @Override
        public BooleanSupplier disabledStatusSupplier() {
            return this.isConfigDisabled;
        }
    }

    public static final class LoadedData {
        private final DebuffAttributes attributes;
        private final List<DebuffStage> stages;
        private final List<DebuffSource> sources;

        public LoadedData(DebuffAttributes attributes, List<DebuffStage> stages, List<DebuffSource> sources) {
            this.attributes = attributes;
            this.stages = stages;
            this.sources = sources;
        }
    }

    public static final class DebuffAttributes {
        public static final Codec<DebuffAttributes> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Attribs.LOOKUP_CODEC.fieldOf("delay").forGetter(DebuffAttributes::getDelayAttribute), (App)Attribs.LOOKUP_CODEC.fieldOf("resist").forGetter(DebuffAttributes::getResistanceAttribute), (App)Attribs.LOOKUP_CODEC.fieldOf("block").forGetter(DebuffAttributes::getBlockingAttribute)).apply((Applicative)instance, DebuffAttributes::new));
        private final IAttributeId delayAttribute;
        private final IAttributeId resistAttribute;
        private final IAttributeId blockAttribute;

        public DebuffAttributes(IAttributeId delayAttribute, IAttributeId resistAttribute, IAttributeId blockAttribute) {
            this.delayAttribute = delayAttribute;
            this.resistAttribute = resistAttribute;
            this.blockAttribute = blockAttribute;
        }

        public IAttributeId getDelayAttribute() {
            return this.delayAttribute;
        }

        public IAttributeId getResistanceAttribute() {
            return this.resistAttribute;
        }

        public IAttributeId getBlockingAttribute() {
            return this.blockAttribute;
        }
    }

    public static final class DebuffStage {
        public static final Codec<DebuffStage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)100).fieldOf("limit").forGetter(t -> t.maxApplicableProgress), (App)DebuffStageEventType.EVENT_CODEC.listOf().fieldOf("events").forGetter(t -> t.events)).apply((Applicative)instance, DebuffStage::new));
        public static final DebuffStage NONE = new DebuffStage(Integer.MAX_VALUE, Collections.emptyList());
        private final int maxApplicableProgress;
        private final List<DebuffStageEvent> events;

        public DebuffStage(int maxApplicableProgress, List<DebuffStageEvent> events) {
            this.maxApplicableProgress = maxApplicableProgress;
            this.events = events;
        }

        public boolean isApplicable(int progress) {
            return progress <= this.maxApplicableProgress;
        }

        public void apply(PlayerEntity player) {
            this.events.forEach(event -> event.apply(player));
        }
    }
}

